SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

DROP TABLE IF EXISTS `alerte`;
CREATE TABLE IF NOT EXISTS `alerte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `anagrame_categorii`;
CREATE TABLE IF NOT EXISTS `anagrame_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `anagrame_conectati`;
CREATE TABLE IF NOT EXISTS `anagrame_conectati` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`data`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `anagrame_cuvinte`;
CREATE TABLE IF NOT EXISTS `anagrame_cuvinte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `cuvant` varchar(77) NOT NULL,
  `valid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cuvant` (`cuvant`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `anagrame_raspunsuri`;
CREATE TABLE IF NOT EXISTS `anagrame_raspunsuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `baiatul_zilei`;
CREATE TABLE IF NOT EXISTS `baiatul_zilei` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `voturi` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `baiatul_zilei_din`;
CREATE TABLE IF NOT EXISTS `baiatul_zilei_din` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` varchar(10) NOT NULL,
  `voturi` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data` (`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bancuri`;
CREATE TABLE IF NOT EXISTS `bancuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bancuri_abonati`;
CREATE TABLE IF NOT EXISTS `bancuri_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bancuri_aprecieri`;
CREATE TABLE IF NOT EXISTS `bancuri_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bancuri_categorii`;
CREATE TABLE IF NOT EXISTS `bancuri_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bancuri_comentarii`;
CREATE TABLE IF NOT EXISTS `bancuri_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bancuri_note`;
CREATE TABLE IF NOT EXISTS `bancuri_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `barnbuddy_experienta`;
CREATE TABLE IF NOT EXISTS `barnbuddy_experienta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `barnbuddy_magazin`;
CREATE TABLE IF NOT EXISTS `barnbuddy_magazin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(33) NOT NULL,
  `bani` int(11) NOT NULL DEFAULT '0',
  `baniadunati` int(11) NOT NULL DEFAULT '0',
  `timp` int(11) NOT NULL DEFAULT '0',
  `tip` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;

INSERT INTO `barnbuddy_magazin` (`id`, `nume`, `bani`, `baniadunati`, `timp`, `tip`) VALUES
(1, 'Trifoi', 40, 45, 1, 0),
(2, 'Ridiche', 120, 135, 2, 0),
(3, 'Avocado', 189, 240, 4, 0),
(4, 'Nap', 247, 441, 10, 0),
(5, 'Morcov', 373, 675, 15, 0),
(6, 'Porumb', 512, 924, 20, 0),
(7, 'Cartofi', 619, 1140, 25, 0),
(8, 'Vinete', 744, 1386, 30, 0),
(9, 'Rosii', 877, 1638, 25, 0),
(10, 'Ardei', 922, 1782, 28, 0),
(11, 'Castravete', 973, 1872, 29, 0),
(12, 'Dovleac', 1579, 2700, 35, 0),
(13, 'Mar', 1811, 3120, 35, 0),
(14, 'Pepene', 1962, 3480, 36, 0),
(15, 'Capsuni', 2679, 4410, 39, 0),
(16, 'Banane', 2889, 4836, 43, 0),
(17, 'Piersica', 3042, 5226, 47, 0),
(18, 'Portocale', 3355, 5670, 49, 0),
(19, 'Struguri', 4127, 6972, 49, 0),
(20, 'Cocos', 5150, 8208, 50, 0),
(21, 'Margareta', 1740, 1880, 8, 1),
(22, 'Crizantema', 3170, 3482, 12, 1),
(23, 'Garoafa', 4540, 4860, 14, 1),
(24, 'Hortensie', 6470, 6816, 15, 1),
(25, 'Crin', 8240, 8684, 18, 1),
(26, 'Floarea-soarelui', 10460, 10976, 20, 1),
(27, 'Iris', 15140, 16182, 24, 1),
(28, 'Lalea', 17990, 19272, 26, 1),
(29, 'Narcisa', 21110, 23240, 28, 1),
(30, 'Trandafir', 25000, 27500, 30, 1),
(31, 'Orhidee', 29130, 32562, 35, 1),
(32, 'Fertilizare1', 50, 0, 1, 2),
(33, 'Fertilizare2', 200, 0, 2, 2),
(34, 'Fertilizare3', 500, 0, 5, 2),
(35, 'Fertilizare4', 1000, 0, 10, 2),
(36, 'Fertilizare5', 2000, 0, 20, 2),
(37, 'Fertilizare6', 3000, 0, 30, 2),
(38, 'Fertilizare7', 4000, 0, 40, 2),
(39, 'Fertilizare8', 5000, 0, 50, 2),
(40, 'Oaie', 62396, 45, 6, 3),
(41, 'Gaina', 91570, 112, 8, 3),
(42, 'Porc', 49840, 40, 6, 3),
(43, 'Panda', 205323, 150, 6, 3),
(44, 'Tigru', 410790, 250, 6, 3),
(45, 'Capra', 67564, 35, 6, 3),
(46, 'Gasca', 80640, 65, 6, 3),
(47, 'Rata', 67564, 30, 6, 3),
(48, 'Vaca', 94700, 80, 6, 3),
(49, 'Cal', 156070, 95, 6, 3),
(50, 'Cangur', 65560, 40, 6, 3),
(51, 'Magar', 73542, 45, 6, 3),
(52, 'Cocosh', 62854, 40, 8, 3),
(53, 'Emu', 96435, 65, 6, 3),
(54, 'Ren', 110490, 55, 6, 3),
(55, 'Elefant', 160542, 100, 6, 3);

DROP TABLE IF EXISTS `barnbuddy_membrii`;
CREATE TABLE IF NOT EXISTS `barnbuddy_membrii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `vizite` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  `databani` int(11) NOT NULL DEFAULT '0',
  `dataplantare` int(11) NOT NULL DEFAULT '0',
  `care` int(11) DEFAULT '0',
  `pamant` int(2) DEFAULT '0',
  `dataudare` int(11) NOT NULL DEFAULT '0',
  `insecte` int(1) NOT NULL DEFAULT '0',
  `buruieni` int(1) NOT NULL DEFAULT '0',
  `datainsecte` int(11) NOT NULL DEFAULT '0',
  `databuruieni` int(11) NOT NULL DEFAULT '0',
  `datahranire` int(11) NOT NULL DEFAULT '0',
  `premiu` int(11) NOT NULL DEFAULT '0',
  `premiudata` int(11) NOT NULL DEFAULT '0',
  `bani` int(11) NOT NULL DEFAULT '1000',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `barnbuddy_pamant`;
CREATE TABLE IF NOT EXISTS `barnbuddy_pamant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bani` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO `barnbuddy_pamant` (`id`, `bani`) VALUES
(1, 3000),
(2, 5000),
(3, 10000),
(4, 15000),
(5, 25000),
(6, 50000),
(7, 75000),
(8, 100000),
(9, 150000),
(10, 175000),
(11, 225000),
(12, 255000),
(13, 315000),
(14, 375000),
(15, 400000),
(16, 450000),
(17, 485000),
(18, 550000),
(19, 662000),
(20, 750000);

DROP TABLE IF EXISTS `barnbuddy_plante`;
CREATE TABLE IF NOT EXISTS `barnbuddy_plante` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `tip` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `biblia_carti`;
CREATE TABLE IF NOT EXISTS `biblia_carti` (
  `carte` int(2) NOT NULL,
  `capitole` int(3) NOT NULL,
  `nume_carte1` varchar(77) NOT NULL,
  PRIMARY KEY (`carte`),
  UNIQUE KEY `carte` (`carte`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `biblia_carti` (`carte`, `capitole`, `nume_carte1`) VALUES
(1, 50, 'Geneza');

DROP TABLE IF EXISTS `biblia_categorii`;
CREATE TABLE IF NOT EXISTS `biblia_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  `nume_scurt` varchar(33) NOT NULL,
  `descriere` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `biblia_categorii` (`id`, `nume`, `nume_scurt`, `descriere`) VALUES
(1, 'Traducerea dupa Dumitru Cornilescu (versiune corectata)', 'DCC', 'Informatii traducere: <a href=\"http://biblia.pentruviata.ro/bib_text.php\">biblia.pentruviata.ro</a>');

DROP TABLE IF EXISTS `biblia_texte`;
CREATE TABLE IF NOT EXISTS `biblia_texte` (
  `id` int(5) NOT NULL,
  `testament` int(1) NOT NULL,
  `pagina` int(4) NOT NULL,
  `carte` int(2) NOT NULL,
  `capitol` int(3) NOT NULL,
  `verset` int(3) NOT NULL,
  `text1` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `biblia_texte` (`id`, `testament`, `pagina`, `carte`, `capitol`, `verset`, `text1`) VALUES
(1, 1, 1, 1, 1, 1, 'La început, Dumnezeu a făcut cerurile şi pământul.');

DROP TABLE IF EXISTS `biblia_titluri`;
CREATE TABLE IF NOT EXISTS `biblia_titluri` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `verset` int(5) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `biblia_titluri` (`id`, `verset`, `text`) VALUES
(1, 1, 'Facerea lumii.');

DROP TABLE IF EXISTS `biblia_trimiteri`;
CREATE TABLE IF NOT EXISTS `biblia_trimiteri` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `verset` int(5) NOT NULL,
  `id_trimitere` int(5) NOT NULL,
  `text` varchar(77) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `biblia_trimiteri` (`id`, `verset`, `id_trimitere`, `text`) VALUES
(1, 1, 26046, 'Ioan 1.1-2');

DROP TABLE IF EXISTS `biblioteca_carti`;
CREATE TABLE IF NOT EXISTS `biblioteca_carti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `biblioteca_categorii`;
CREATE TABLE IF NOT EXISTS `biblioteca_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `biblioteca_comentarii`;
CREATE TABLE IF NOT EXISTS `biblioteca_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `biblioteca_semne`;
CREATE TABLE IF NOT EXISTS `biblioteca_semne` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `biblioteca_texte`;
CREATE TABLE IF NOT EXISTS `biblioteca_texte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `blog_abonati`;
CREATE TABLE IF NOT EXISTS `blog_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `blog_aprecieri`;
CREATE TABLE IF NOT EXISTS `blog_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `blog_articole`;
CREATE TABLE IF NOT EXISTS `blog_articole` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `blog_categorii`;
CREATE TABLE IF NOT EXISTS `blog_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `blog_comentarii`;
CREATE TABLE IF NOT EXISTS `blog_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `blog_note`;
CREATE TABLE IF NOT EXISTS `blog_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `browsere_blocate`;
CREATE TABLE IF NOT EXISTS `browsere_blocate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `browser` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `browser` (`browser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cantari`;
CREATE TABLE IF NOT EXISTS `cantari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cantari_abonati`;
CREATE TABLE IF NOT EXISTS `cantari_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cantari_aprecieri`;
CREATE TABLE IF NOT EXISTS `cantari_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cantari_categorii`;
CREATE TABLE IF NOT EXISTS `cantari_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cantari_comentarii`;
CREATE TABLE IF NOT EXISTS `cantari_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cantari_note`;
CREATE TABLE IF NOT EXISTS `cantari_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `casatorii_cupluri`;
CREATE TABLE IF NOT EXISTS `casatorii_cupluri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `citit` int(11) NOT NULL,
  `romantism` int(11) DEFAULT '0',
  `copii` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `casatorii_produse`;
CREATE TABLE IF NOT EXISTS `casatorii_produse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) DEFAULT NULL,
  `tip` int(1) NOT NULL,
  `sex` char(1) NOT NULL,
  `pret` int(11) NOT NULL,
  `puncte` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `casatorii_produse` (`id`, `nume`, `tip`, `sex`, `pret`, `puncte`) VALUES
(1, 'la o cină romantică', 1, '0', 100, 4),
(2, 'la o plimbare în parc', 1, '0', 50, 2),
(3, 'la o ieșire obișnuită în oraș', 1, '0', 30, 1),
(4, 'într-o excursie de neuitat', 1, '0', 300, 6),
(5, 'la cinema', 1, '0', 120, 4),
(6, 'prezervativ', 2, 'M', 20, 4),
(7, 'anticoncepționale', 2, 'F', 60, 4),
(8, 'vibrator', 2, 'F', 150, 2),
(9, 'casete porno', 2, 'M', 200, 6),
(10, 'jucării erotice', 2, 'M', 135, 3),
(11, 'jucării erotice', 2, 'F', 135, 3),
(12, 'fără', 2, '0', 0, 4);

DROP TABLE IF EXISTS `casatorii_produse_cumparate`;
CREATE TABLE IF NOT EXISTS `casatorii_produse_cumparate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `tip` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `casatorii_produse_oferite`;
CREATE TABLE IF NOT EXISTS `casatorii_produse_oferite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `tip` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `casatorii_virtuale`;
CREATE TABLE IF NOT EXISTS `casatorii_virtuale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `divort` int(11) DEFAULT '0',
  `citit` int(11) NOT NULL,
  `dataiesire` int(11) DEFAULT '0',
  `datasex` int(11) DEFAULT '0',
  `tip` int(1) NOT NULL,
  `cerere` int(1) NOT NULL,
  `declaratie` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `chat_arhiva`;
CREATE TABLE IF NOT EXISTS `chat_arhiva` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `chat_camere`;
CREATE TABLE IF NOT EXISTS `chat_camere` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clid` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  `activitate` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `parola` varchar(33) NOT NULL,
  `static` int(1) NOT NULL,
  `raportat` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `chat_conectati`;
CREATE TABLE IF NOT EXISTS `chat_conectati` (
  `de` int(11) NOT NULL,
  `cid` int(1) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`data`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `chat_mesaje`;
CREATE TABLE IF NOT EXISTS `chat_mesaje` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `raportat` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `chat_moduri`;
CREATE TABLE IF NOT EXISTS `chat_moduri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(10) NOT NULL,
  `img` varchar(100) NOT NULL,
  `dscr` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `chat_moduri` (`id`, `text`, `img`, `dscr`) VALUES
(1, ':<', '1.gif', ''),
(2, ':(', '2.gif', ''),
(3, ':>', '3.gif', ''),
(4, ':)', '4.gif', ''),
(5, ':p', '5.gif', ''),
(6, ';)', '6.gif', ''),
(7, ':D', '7.gif', ''),
(8, ':3', '8.gif', ''),
(9, ';(', '9.gif', ''),
(10, '%', '10.gif', '');

DROP TABLE IF EXISTS `chestionar_intrebari`;
CREATE TABLE IF NOT EXISTS `chestionar_intrebari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `intrebare` varchar(333) NOT NULL,
  `varianta1` varchar(333) NOT NULL,
  `varianta2` varchar(333) NOT NULL,
  `varianta3` varchar(333) NOT NULL,
  `varianta4` varchar(333) NOT NULL,
  `varianta5` varchar(333) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `chestionar_raspunsuri`;
CREATE TABLE IF NOT EXISTS `chestionar_raspunsuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `de` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `comentarii_profil`;
CREATE TABLE IF NOT EXISTS `comentarii_profil` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `contact`;
CREATE TABLE IF NOT EXISTS `contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `email` varchar(77) NOT NULL,
  `telefon` varchar(20) NOT NULL,
  `subiect` varchar(33) NOT NULL,
  `text` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `browser` varchar(333) NOT NULL,
  `valid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cuvinte_interzise`;
CREATE TABLE IF NOT EXISTS `cuvinte_interzise` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cuvant` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cuvant` (`cuvant`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cuvinte_predefinite`;
CREATE TABLE IF NOT EXISTS `cuvinte_predefinite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cod` varchar(77) NOT NULL,
  `text` varchar(777) NOT NULL,
  `vizibil` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cod` (`cod`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cuvinte_raportate`;
CREATE TABLE IF NOT EXISTS `cuvinte_raportate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cuvant` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cuvant` (`cuvant`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `daruri`;
CREATE TABLE IF NOT EXISTS `daruri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(333) NOT NULL,
  `link` varchar(333) NOT NULL,
  `descriere` varchar(333) NOT NULL,
  `pret` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `daruri_oferite`;
CREATE TABLE IF NOT EXISTS `daruri_oferite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_abonati`;
CREATE TABLE IF NOT EXISTS `descarcari_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_albume`;
CREATE TABLE IF NOT EXISTS `descarcari_albume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `logo1` varchar(255) NOT NULL,
  `logo2` varchar(255) NOT NULL,
  `logo3` varchar(255) NOT NULL,
  `logo4` varchar(255) NOT NULL,
  `logo5` varchar(255) NOT NULL,
  `link` varchar(777) NOT NULL,
  `descriere` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`),
  UNIQUE KEY `nume_2` (`nume`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_aprecieri`;
CREATE TABLE IF NOT EXISTS `descarcari_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_categorii`;
CREATE TABLE IF NOT EXISTS `descarcari_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_comentarii`;
CREATE TABLE IF NOT EXISTS `descarcari_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_fisiere`;
CREATE TABLE IF NOT EXISTS `descarcari_fisiere` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_nou` int(11) NOT NULL DEFAULT '0',
  `de` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `link` varchar(777) NOT NULL,
  `vizibil` int(1) NOT NULL DEFAULT '1',
  `dimensiune` bigint(15) DEFAULT NULL,
  `descriere` varchar(777) NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `descarcari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL DEFAULT '0',
  `validd` int(11) NOT NULL DEFAULT '0',
  `durata` int(11) NOT NULL DEFAULT '0',
  `rata` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `descarcari_note`;
CREATE TABLE IF NOT EXISTS `descarcari_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `devotionale`;
CREATE TABLE IF NOT EXISTS `devotionale` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `devotionale_abonati`;
CREATE TABLE IF NOT EXISTS `devotionale_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `devotionale_aprecieri`;
CREATE TABLE IF NOT EXISTS `devotionale_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `devotionale_categorii`;
CREATE TABLE IF NOT EXISTS `devotionale_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `devotionale_comentarii`;
CREATE TABLE IF NOT EXISTS `devotionale_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `devotionale_note`;
CREATE TABLE IF NOT EXISTS `devotionale_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `elemente_editate`;
CREATE TABLE IF NOT EXISTS `elemente_editate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(33) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `elemente_ramase`;
CREATE TABLE IF NOT EXISTS `elemente_ramase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `la` int(11) NOT NULL,
  `link` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `la` (`la`,`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eroul`;
CREATE TABLE IF NOT EXISTS `eroul` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `bani` int(11) NOT NULL DEFAULT '1000',
  `viata` int(2) NOT NULL DEFAULT '0',
  `putere` int(11) NOT NULL DEFAULT '0',
  `vizite` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  `databani` int(11) NOT NULL,
  `premiu` int(11) NOT NULL DEFAULT '0',
  `premiudata` int(11) NOT NULL DEFAULT '0',
  `care` int(11) NOT NULL DEFAULT '0',
  `timpviata` int(11) NOT NULL DEFAULT '0',
  `timpaventura` int(11) NOT NULL DEFAULT '0',
  `timpatac` int(11) NOT NULL DEFAULT '0',
  `nivel` int(11) NOT NULL DEFAULT '1',
  `aventuri` int(11) NOT NULL DEFAULT '0',
  `atacuri` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `evenimente`;
CREATE TABLE IF NOT EXISTS `evenimente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `tip` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fata_zilei`;
CREATE TABLE IF NOT EXISTS `fata_zilei` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `voturi` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `fata_zilei_din`;
CREATE TABLE IF NOT EXISTS `fata_zilei_din` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` varchar(10) NOT NULL,
  `voturi` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data` (`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_abonati_forumuri`;
CREATE TABLE IF NOT EXISTS `forum_abonati_forumuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_abonati_topicuri`;
CREATE TABLE IF NOT EXISTS `forum_abonati_topicuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `citit` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_categorii`;
CREATE TABLE IF NOT EXISTS `forum_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  `pozitie` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_conectati`;
CREATE TABLE IF NOT EXISTS `forum_conectati` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`data`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_forumuri`;
CREATE TABLE IF NOT EXISTS `forum_forumuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `clid` int(11) NOT NULL DEFAULT '0',
  `nume` varchar(77) NOT NULL,
  `inchis` int(1) NOT NULL DEFAULT '0',
  `pozitie` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`),
  UNIQUE KEY `nume_2` (`nume`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_postari`;
CREATE TABLE IF NOT EXISTS `forum_postari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `citat` int(11) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `forum_topicuri`;
CREATE TABLE IF NOT EXISTS `forum_topicuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `tid` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  `activitate` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `inchis` int(1) NOT NULL DEFAULT '0',
  `urcat` int(1) NOT NULL DEFAULT '0',
  `mutat` char(1) NOT NULL DEFAULT '0',
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`,`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `galerie_albume`;
CREATE TABLE IF NOT EXISTS `galerie_albume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `tip` int(1) NOT NULL,
  `valoare` varchar(33) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `galerie_aprecieri`;
CREATE TABLE IF NOT EXISTS `galerie_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `galerie_comentarii`;
CREATE TABLE IF NOT EXISTS `galerie_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `galerie_note`;
CREATE TABLE IF NOT EXISTS `galerie_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `galerie_poze`;
CREATE TABLE IF NOT EXISTS `galerie_poze` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `sex` int(1) NOT NULL,
  `nume_original` varchar(33) NOT NULL,
  `mare` varchar(77) NOT NULL,
  `mica` varchar(77) NOT NULL,
  `descriere` varchar(333) NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  `valid` int(11) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `gradina_membrii`;
CREATE TABLE IF NOT EXISTS `gradina_membrii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `numegradina` varchar(30) NOT NULL DEFAULT '',
  `descriere` varchar(500) NOT NULL DEFAULT '',
  `vizite` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  `databani` int(11) NOT NULL DEFAULT '0',
  `dataplantare` int(11) NOT NULL DEFAULT '0',
  `dataplantarex` int(11) NOT NULL DEFAULT '0',
  `care` int(11) NOT NULL DEFAULT '0',
  `dataudare` int(11) NOT NULL DEFAULT '0',
  `bani` int(11) NOT NULL DEFAULT '150',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `gradina_plante`;
CREATE TABLE IF NOT EXISTS `gradina_plante` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(33) NOT NULL,
  `pret` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `gradina_plante` (`id`, `nume`, `pret`) VALUES
(1, 'morcov', 50),
(2, 'cartofi', 75),
(3, 'trandafir', 100),
(4, 'ciuperca', 50),
(5, 'castravete', 75),
(6, 'lacramioare', 100),
(7, 'ceapa', 75),
(8, 'ghiocei', 25),
(9, 'narcise', 50),
(10, 'brad', 50),
(11, 'capsuni', 75);

DROP TABLE IF EXISTS `gradina_plante_cumparate`;
CREATE TABLE IF NOT EXISTS `gradina_plante_cumparate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `gradina_seminte`;
CREATE TABLE IF NOT EXISTS `gradina_seminte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(33) NOT NULL,
  `pret` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `gradina_seminte` (`id`, `nume`, `pret`) VALUES
(1, 'morcov', 5000),
(2, 'cartofi', 7500),
(3, 'trandafir', 10000),
(4, 'ciuperca', 5000),
(5, 'castravete', 7500),
(6, 'lacramioare', 10000),
(7, 'ceapa', 7500),
(8, 'ghiocei', 2500),
(9, 'narcise', 5000),
(10, 'brad', 5000),
(11, 'capsuni', 7500);

DROP TABLE IF EXISTS `gradina_seminte_cumparate`;
CREATE TABLE IF NOT EXISTS `gradina_seminte_cumparate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `grupuri`;
CREATE TABLE IF NOT EXISTS `grupuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `descriere` varchar(333) NOT NULL,
  `reguli` text NOT NULL,
  `logo` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `grup_anunturi`;
CREATE TABLE IF NOT EXISTS `grup_anunturi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `grup_membrii`;
CREATE TABLE IF NOT EXISTS `grup_membrii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  `dezabonat` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ignorati`;
CREATE TABLE IF NOT EXISTS `ignorati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`la`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `imagini_avatare`;
CREATE TABLE IF NOT EXISTS `imagini_avatare` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(333) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `imagini_iconite`;
CREATE TABLE IF NOT EXISTS `imagini_iconite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(1) NOT NULL,
  `link` varchar(333) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `imagini_iconite` (`id`, `pid`, `link`) VALUES
(1, 3, 'img/logouri/logo.png');

DROP TABLE IF EXISTS `imagini_zambareti`;
CREATE TABLE IF NOT EXISTS `imagini_zambareti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `scode` varchar(15) NOT NULL,
  `imgsrc` varchar(200) NOT NULL,
  `vizibil` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `scode` (`scode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `imagini_zambareti_favoriti`;
CREATE TABLE IF NOT EXISTS `imagini_zambareti_favoriti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `istoric_browsere`;
CREATE TABLE IF NOT EXISTS `istoric_browsere` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `browser` varchar(255) NOT NULL,
  UNIQUE KEY `de` (`de`,`browser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `istoric_logari`;
CREATE TABLE IF NOT EXISTS `istoric_logari` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `browser` varchar(333) NOT NULL,
  `browser2` varchar(333) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `istoric_nume`;
CREATE TABLE IF NOT EXISTS `istoric_nume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(33) NOT NULL,
  `valid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `istoric_vizite_profil`;
CREATE TABLE IF NOT EXISTS `istoric_vizite_profil` (
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `jurnal_admini`;
CREATE TABLE IF NOT EXISTS `jurnal_admini` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `lista_identitati`;
CREATE TABLE IF NOT EXISTS `lista_identitati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=100001 DEFAULT CHARSET=utf8;

INSERT INTO `lista_identitati` (`id`) VALUES
(1);

DROP TABLE IF EXISTS `localitati`;
CREATE TABLE IF NOT EXISTS `localitati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `siruta` bigint(20) NOT NULL,
  `longitudine` decimal(18,16) NOT NULL,
  `latitudine` decimal(18,16) NOT NULL,
  `nume` varchar(64) NOT NULL,
  `judet` varchar(64) NOT NULL,
  `jud` varchar(2) NOT NULL,
  `regiune` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `localitati` (`id`, `siruta`, `longitudine`, `latitudine`, `nume`, `judet`, `jud`, `regiune`) VALUES
(1, 69919, '23.8032646645854450', '44.3185460894783180', 'Craiova', 'Dolj', 'DJ', 'Sud-Vest - Oltenia');

DROP TABLE IF EXISTS `magazin_cumparaturi`;
CREATE TABLE IF NOT EXISTS `magazin_cumparaturi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `magazin_produse`;
CREATE TABLE IF NOT EXISTS `magazin_produse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  `link` varchar(333) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime`;
CREATE TABLE IF NOT EXISTS `maxime` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime_abonati`;
CREATE TABLE IF NOT EXISTS `maxime_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime_aprecieri`;
CREATE TABLE IF NOT EXISTS `maxime_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime_categorii`;
CREATE TABLE IF NOT EXISTS `maxime_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime_comentarii`;
CREATE TABLE IF NOT EXISTS `maxime_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime_note`;
CREATE TABLE IF NOT EXISTS `maxime_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxime_random`;
CREATE TABLE IF NOT EXISTS `maxime_random` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `maxim_conectati`;
CREATE TABLE IF NOT EXISTS `maxim_conectati` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ddt` varchar(20) NOT NULL,
  `dtm` varchar(20) NOT NULL,
  `ppl` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `meditatii`;
CREATE TABLE IF NOT EXISTS `meditatii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `meditatii_abonati`;
CREATE TABLE IF NOT EXISTS `meditatii_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `meditatii_aprecieri`;
CREATE TABLE IF NOT EXISTS `meditatii_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `meditatii_categorii`;
CREATE TABLE IF NOT EXISTS `meditatii_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `meditatii_comentarii`;
CREATE TABLE IF NOT EXISTS `meditatii_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `meditatii_note`;
CREATE TABLE IF NOT EXISTS `meditatii_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `melodia_zilei`;
CREATE TABLE IF NOT EXISTS `melodia_zilei` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` varchar(10) NOT NULL,
  `nume` varchar(333) NOT NULL,
  `id1` int(11) NOT NULL DEFAULT '0',
  `id2` int(11) NOT NULL DEFAULT '0',
  `id3` int(11) NOT NULL DEFAULT '0',
  `id4` int(11) NOT NULL DEFAULT '0',
  `id5` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `data` (`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `membrii`;
CREATE TABLE IF NOT EXISTS `membrii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(33) NOT NULL,
  `parola` varchar(33) NOT NULL,
  `prostie` varchar(15) NOT NULL DEFAULT '777',
  `parolada` char(1) NOT NULL DEFAULT '0',
  `parolaprofil` varchar(33) NOT NULL,
  `modprofil` char(1) NOT NULL DEFAULT '0',
  `mod_profil` int(1) NOT NULL DEFAULT '2',
  `sterg_cont` int(11) DEFAULT NULL,
  `cont_dezactivat` int(11) NOT NULL DEFAULT '0',
  `compro` char(1) NOT NULL DEFAULT '0',
  `lista_prieteni` char(1) NOT NULL DEFAULT '0',
  `invitatde` int(11) NOT NULL,
  `data_nastere` varchar(10) NOT NULL,
  `sex` char(1) NOT NULL,
  `location` varchar(100) NOT NULL DEFAULT '',
  `locatie2` varchar(100) NOT NULL DEFAULT '',
  `perm` char(1) NOT NULL DEFAULT '0',
  `items_per_page` int(3) NOT NULL DEFAULT '10',
  `mod_paginare` int(1) NOT NULL DEFAULT '0',
  `mod_jos` int(1) NOT NULL DEFAULT '0',
  `auto_refresh` int(3) NOT NULL DEFAULT '30',
  `postari` int(11) NOT NULL DEFAULT '0',
  `lei` int(11) NOT NULL DEFAULT '0',
  `banca_lei` int(11) NOT NULL DEFAULT '0',
  `euro` int(11) NOT NULL DEFAULT '0',
  `banca_euro` int(11) NOT NULL DEFAULT '0',
  `descriere` varchar(333) NOT NULL DEFAULT '',
  `avatar` varchar(100) NOT NULL DEFAULT '',
  `mod_avatare` varchar(15) NOT NULL DEFAULT 'rotund',
  `melodie_favorita` int(11) NOT NULL DEFAULT '0',
  `icon_nume` varchar(250) NOT NULL,
  `culoare_nume` varchar(15) NOT NULL,
  `email` varchar(50) NOT NULL DEFAULT '',
  `confirm_email` int(1) NOT NULL DEFAULT '0',
  `browser` varchar(333) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `activitate` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `mesaje_chat` int(11) NOT NULL DEFAULT '0',
  `chmood` int(11) NOT NULL DEFAULT '0',
  `chefpm` varchar(333) NOT NULL,
  `status_prieteni` varchar(333) NOT NULL DEFAULT '',
  `lstmass` int(11) NOT NULL,
  `lastpnreas` varchar(100) NOT NULL DEFAULT '',
  `lastplreas` varchar(100) NOT NULL DEFAULT '',
  `cadoul` int(11) NOT NULL DEFAULT '0',
  `timp_cadoul` int(11) NOT NULL DEFAULT '0',
  `mesaje_instant` int(11) NOT NULL DEFAULT '0',
  `mod_daruri` int(1) NOT NULL DEFAULT '0',
  `popmsg` char(1) NOT NULL DEFAULT '0',
  `modpm` char(1) NOT NULL DEFAULT '0',
  `automsgs` char(1) NOT NULL DEFAULT '0',
  `cereri_prietenie` int(1) NOT NULL DEFAULT '0',
  `valid` int(11) NOT NULL,
  `tema` varchar(33) NOT NULL DEFAULT 'albastru_small',
  `vizibil` int(1) NOT NULL DEFAULT '0',
  `hvia` char(1) NOT NULL DEFAULT '1',
  `puncte_joc` int(11) NOT NULL DEFAULT '0',
  `status` varchar(333) NOT NULL DEFAULT '',
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `profil` char(1) NOT NULL DEFAULT '0',
  `oricine` char(1) NOT NULL,
  `cult` int(2) NOT NULL DEFAULT '0',
  `stare_civila` int(2) NOT NULL DEFAULT '0',
  `moto` varchar(200) NOT NULL DEFAULT '',
  `inaltime` varchar(4) NOT NULL DEFAULT '',
  `greutate` char(3) NOT NULL DEFAULT '',
  `ochi` varchar(15) NOT NULL DEFAULT '',
  `par` varchar(15) NOT NULL DEFAULT '',
  `ipla` varchar(200) NOT NULL DEFAULT '',
  `npla` varchar(200) NOT NULL DEFAULT '',
  `obb` varchar(333) NOT NULL,
  `obr` varchar(333) NOT NULL,
  `calitati` varchar(333) NOT NULL,
  `defecte` varchar(333) NOT NULL,
  `muzica` varchar(77) NOT NULL,
  `sport` varchar(77) NOT NULL,
  `profesie` varchar(100) NOT NULL DEFAULT '',
  `trivia` int(11) NOT NULL DEFAULT '0',
  `spune_cartea` int(11) NOT NULL DEFAULT '0',
  `anagrame` int(11) NOT NULL DEFAULT '0',
  `varianta_biblia` int(2) NOT NULL DEFAULT '1',
  `otime` int(11) NOT NULL DEFAULT '0',
  `top_alerte` int(11) NOT NULL DEFAULT '0',
  `top_daruri` int(11) NOT NULL DEFAULT '0',
  `top_mesaje` int(11) NOT NULL DEFAULT '0',
  `instant` char(1) NOT NULL DEFAULT '0',
  `galerie` char(1) NOT NULL DEFAULT '0',
  `forumban` char(1) NOT NULL DEFAULT '0',
  `chat` char(1) NOT NULL DEFAULT '0',
  `posta` char(1) NOT NULL DEFAULT '0',
  `poze` char(1) NOT NULL DEFAULT '0',
  `vizite` int(11) NOT NULL DEFAULT '0',
  `logat` int(11) NOT NULL DEFAULT '0',
  `lastvst` int(11) NOT NULL DEFAULT '0',
  `iconite` varchar(250) NOT NULL DEFAULT '0',
  `codrecuperare` varchar(33) NOT NULL DEFAULT '',
  `quiz_score` varchar(250) NOT NULL DEFAULT '0',
  `total_score` varchar(250) NOT NULL DEFAULT '0',
  `quiz_easy` varchar(250) NOT NULL DEFAULT '0',
  `quiz_medium` varchar(250) NOT NULL DEFAULT '0',
  `quiz_hard` varchar(250) NOT NULL DEFAULT '0',
  `meniu_orasite` varchar(25) NOT NULL,
  `meniu_instantadmini` varchar(25) NOT NULL,
  `meniu_mesajprim` varchar(25) NOT NULL,
  `meniu_cadoul` varchar(25) NOT NULL,
  `meniu_anunturi` varchar(25) NOT NULL,
  `meniu_topicaleatoriu` varchar(25) NOT NULL,
  `meniu_playlist` varchar(25) NOT NULL,
  `meniu_meditatiazilei` varchar(25) NOT NULL,
  `meniu_melodiazilei` varchar(25) NOT NULL,
  `meniu_instant` varchar(25) NOT NULL,
  `meniu_evenimente` varchar(25) NOT NULL,
  `meniu_mesaje` varchar(25) NOT NULL,
  `meniu_notificari` varchar(25) NOT NULL,
  `meniu_casatorii_virtuale` varchar(25) NOT NULL,
  `meniu_prieteni` varchar(25) NOT NULL,
  `meniu_cereriprietenie` varchar(25) NOT NULL,
  `meniu_conectati` varchar(25) NOT NULL,
  `meniu_chat` varchar(25) NOT NULL,
  `meniu_grupuri` varchar(25) NOT NULL,
  `meniu_forum` varchar(25) NOT NULL,
  `meniu_biblia` varchar(25) NOT NULL,
  `meniu_extra` varchar(25) NOT NULL,
  `meniu_invita` varchar(25) NOT NULL,
  `meniu_blog` varchar(25) NOT NULL,
  `meniu_setari` varchar(25) NOT NULL,
  `meniu_jocuri` varchar(25) NOT NULL,
  `meniu_descarcari` varchar(25) NOT NULL,
  `meniu_galerie` varchar(25) NOT NULL,
  `meniu_parteneri` varchar(25) NOT NULL,
  `meniu_regulament` varchar(25) NOT NULL,
  `meniu_deconectare` varchar(25) NOT NULL,
  `meniu_versiune` varchar(25) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `membrii` (`id`, `nume`, `parola`, `prostie`, `parolada`, `parolaprofil`, `modprofil`, `mod_profil`, `sterg_cont`, `cont_dezactivat`, `compro`, `lista_prieteni`, `invitatde`, `data_nastere`, `sex`, `location`, `locatie2`, `perm`, `items_per_page`, `mod_paginare`, `mod_jos`, `auto_refresh`, `postari`, `lei`, `banca_lei`, `euro`, `banca_euro`, `descriere`, `avatar`, `mod_avatare`, `melodie_favorita`, `icon_nume`, `culoare_nume`, `email`, `confirm_email`, `browser`, `ip`, `activitate`, `data`, `mesaje_chat`, `chmood`, `chefpm`, `status_prieteni`, `lstmass`, `lastpnreas`, `lastplreas`, `cadoul`, `timp_cadoul`, `mesaje_instant`, `mod_daruri`, `popmsg`, `modpm`, `automsgs`, `cereri_prietenie`, `valid`, `tema`, `vizibil`, `hvia`, `puncte_joc`, `status`, `vizualizari`, `profil`, `oricine`, `cult`, `stare_civila`, `moto`, `inaltime`, `greutate`, `ochi`, `par`, `ipla`, `npla`, `obb`, `obr`, `calitati`, `defecte`, `muzica`, `sport`, `profesie`, `trivia`, `spune_cartea`, `anagrame`, `varianta_biblia`, `otime`, `top_alerte`, `top_daruri`, `top_mesaje`, `instant`, `galerie`, `forumban`, `chat`, `posta`, `poze`, `vizite`, `logat`, `lastvst`, `iconite`, `codrecuperare`, `quiz_score`, `total_score`, `quiz_easy`, `quiz_medium`, `quiz_hard`, `meniu_orasite`, `meniu_instantadmini`, `meniu_mesajprim`, `meniu_cadoul`, `meniu_anunturi`, `meniu_topicaleatoriu`, `meniu_playlist`, `meniu_meditatiazilei`, `meniu_melodiazilei`, `meniu_instant`, `meniu_evenimente`, `meniu_mesaje`, `meniu_notificari`, `meniu_casatorii_virtuale`, `meniu_prieteni`, `meniu_cereriprietenie`, `meniu_conectati`, `meniu_chat`, `meniu_grupuri`, `meniu_forum`, `meniu_biblia`, `meniu_extra`, `meniu_invita`, `meniu_blog`, `meniu_setari`, `meniu_jocuri`, `meniu_descarcari`, `meniu_galerie`, `meniu_parteneri`, `meniu_regulament`, `meniu_deconectare`, `meniu_versiune`) VALUES
(1, 'Admin', '21232f297a57a5a743894a0e4a801fc3', '777', '0', '', '0', 2, NULL, 0, '0', '0', 0, '2001-02-03', 'M', 'Alte țări', '', '4', 10, 0, 0, 30, 0, 0, 0, 0, 0, '', '', 'rotund', 0, '', '', 'bordanc_nicu@yahoo.com', 0, 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0', '127.0.0.1', 1422997498, 1422997498, 0, 0, '', '', 0, '', '', 0, 0, 0, 0, '0', '0', '0', 0, 1, 'albastru_small', 0, '1', 0, '', 0, '3', '', 0, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 1, 0, 0, 0, 0, '0', '0', '0', '0', '0', '0', 0, 0, 0, '0', '0741476860', '0', '0', '0', '0', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(2, 'Administrator', '21232f297a57a5a743894a0e4a801fc3', '777', '0', '', '0', 2, NULL, 0, '0', '0', 0, '2001-02-03', 'M', 'Alte țări', '', '4', 10, 0, 0, 30, 0, 0, 0, 0, 0, '', '', 'rotund', 0, '', '', 'bordanc_nicu@yahoo.com', 0, 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0', '127.0.0.1', 1422998137, 1422998137, 0, 0, '', '', 0, '', '', 0, 0, 0, 0, '0', '0', '0', 0, 1, 'albastru_small', 0, '1', 0, '', 0, '3', '', 0, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 1, 0, 0, 0, 0, '0', '0', '0', '0', '0', '0', 0, 0, 0, '0', '0741476860', '0', '0', '0', '0', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(3, 'Robot_site', 'filumina.ro', '777', '0', '', '0', 2, NULL, 0, '0', '0', 0, '2001-02-03', 'M', 'Alte țări', '', '0', 10, 0, 0, 30, 0, 0, 0, 0, 0, '', '', 'rotund', 0, '', '', 'bordanc_nicu@yahoo.com', 0, 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0', '127.0.0.1', 1422998186, 1422998186, 0, 0, '', '', 0, '', '', 0, 0, 0, 0, '0', '0', '0', 0, 0, 'albastru_small', 0, '1', 0, '', 0, '3', '', 0, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 1, 0, 0, 0, 0, '0', '0', '0', '0', '0', '0', 0, 0, 0, '0', '0741476860', '0', '0', '0', '0', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(4, 'Vizitator offline', 'filumina.ro', '777', '0', '', '0', 2, NULL, 0, '0', '0', 0, '2001-02-03', 'M', 'Alte țări', '', '0', 10, 0, 0, 30, 0, 0, 0, 0, 0, '', '', 'rotund', 0, '', '', 'bordanc_nicu@yahoo.com', 0, 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0', '127.0.0.1', 1422998211, 1422998211, 0, 0, '', '', 0, '', '', 0, 0, 0, 0, '0', '0', '0', 0, 0, 'albastru_small', 0, '1', 0, '', 0, '3', '', 0, 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 1, 0, 0, 0, 0, '0', '0', '0', '0', '0', '0', 0, 0, 0, '0', '0741476860', '0', '0', '0', '0', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

DROP TABLE IF EXISTS `membrii_conectati`;
CREATE TABLE IF NOT EXISTS `membrii_conectati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `loc` varchar(333) NOT NULL,
  `link` varchar(333) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `membrii_de_sters`;
CREATE TABLE IF NOT EXISTS `membrii_de_sters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `la` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `la` (`la`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `membrii_pedepsiti`;
CREATE TABLE IF NOT EXISTS `membrii_pedepsiti` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `penalty` char(1) NOT NULL,
  `exid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `pnreas` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`exid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje`;
CREATE TABLE IF NOT EXISTS `mesaje` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  `marcat` int(1) NOT NULL DEFAULT '0',
  `raportat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje_instant`;
CREATE TABLE IF NOT EXISTS `mesaje_instant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` varchar(333) NOT NULL,
  `pret_com` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje_instant_admini`;
CREATE TABLE IF NOT EXISTS `mesaje_instant_admini` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` varchar(333) NOT NULL,
  `pret_com` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje_instant_admini_aprecieri`;
CREATE TABLE IF NOT EXISTS `mesaje_instant_admini_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje_instant_admini_comentarii`;
CREATE TABLE IF NOT EXISTS `mesaje_instant_admini_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje_instant_aprecieri`;
CREATE TABLE IF NOT EXISTS `mesaje_instant_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `mesaje_instant_comentarii`;
CREATE TABLE IF NOT EXISTS `mesaje_instant_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `notificari`;
CREATE TABLE IF NOT EXISTS `notificari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `nume_blocate`;
CREATE TABLE IF NOT EXISTS `nume_blocate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(33) NOT NULL,
  `tip` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ora_lei`;
CREATE TABLE IF NOT EXISTS `ora_lei` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `parole_incercate`;
CREATE TABLE IF NOT EXISTS `parole_incercate` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `parola` varchar(33) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `browser` varchar(333) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `parteneri`;
CREATE TABLE IF NOT EXISTS `parteneri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  `link` varchar(333) NOT NULL,
  `logo` varchar(255) NOT NULL DEFAULT '',
  `descarcari` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `poezii`;
CREATE TABLE IF NOT EXISTS `poezii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `poezii_abonati`;
CREATE TABLE IF NOT EXISTS `poezii_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `poezii_aprecieri`;
CREATE TABLE IF NOT EXISTS `poezii_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `poezii_categorii`;
CREATE TABLE IF NOT EXISTS `poezii_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `poezii_comentarii`;
CREATE TABLE IF NOT EXISTS `poezii_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `poezii_note`;
CREATE TABLE IF NOT EXISTS `poezii_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `prieteni`;
CREATE TABLE IF NOT EXISTS `prieteni` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`la`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `quiz_intrebari`;
CREATE TABLE IF NOT EXISTS `quiz_intrebari` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `question` varchar(200) NOT NULL,
  `answer` varchar(30) NOT NULL,
  `difficulty` varchar(12) NOT NULL,
  `number` int(11) NOT NULL,
  `answer1` varchar(50) NOT NULL,
  `answer2` varchar(50) NOT NULL,
  `answer3` varchar(50) NOT NULL,
  `answer4` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `quiz_intrebari` (`id`, `question`, `answer`, `difficulty`, `number`, `answer1`, `answer2`, `answer3`, `answer4`) VALUES
(1, 'Cate zile are un an?', '365', 'easy', 1, '368', '365', '398', '364'),
(2, 'In ce an a cazut comunismul?', '1989', 'easy', 2, '1988', '1987', '1989', '2000'),
(3, 'Cate persoane au scapat de la potop?', '8', 'easy', 3, '6', '4', '5', '8'),
(4, 'Care este apostolul iubirii ?', 'Ioan', 'easy', 4, 'Pavel', 'Petru', 'Ioan', 'Matei'),
(5, 'Cu ce zi incepe saptamana ?', 'Duminica', 'easy', 5, 'Luni', 'Duminica', 'Sambata', 'Vineri'),
(6, 'A cata zi a inviat Isus din morti?', 'a 3-a', 'easy', 6, 'a 2-a', 'a 3-a', 'prima zi', 'a 4-a'),
(7, 'Care om a trait cel mai mult pe pamant?', 'Metusala', 'easy', 7, 'Moise', 'Noe', 'Melhisedec', 'Metusala'),
(8, 'Cum il chema pe socrul lui Moise?', 'Ietro', 'easy', 8, 'Ietro', 'Datan', 'Abiram', 'Ahiezer'),
(9, 'Care a fost prima urgie', 'prefacerea apei in sange', 'easy', 9, 'broastele', 'prefacerea apei in sange', 'ciuma vitelor', 'paduchii'),
(10, 'Cum il cheama pe fratele lui Iacov?', 'Esau', 'easy', 10, 'Iosif', 'Daniel', 'Esau', 'Ruben'),
(11, 'Cati ani a trait Isus pe pamant?', '33', 'med', 1, '30', '35', '33', '32'),
(12, 'La ce varsta a vorbit Isus in Templu?', '12 ani', 'med', 2, '13 ani', '10 ani', '11 ani', '12 ani'),
(13, 'Cate capitole are Apocalipsa?', '22', 'med', 3, '22', '20', '21', '23'),
(14, 'In ce carte, respectiv capitol al Noului Testament se gaseste cuvantul \'nici\' scris de 15 ori?', 'Apocalipsa, cap 18', 'med', 4, 'Apocalipsa, cap 19', 'Apocalipsa, cap 17', 'Apocalipsa, cap 18', 'Apocalipsa, cap 11'),
(15, 'Cate persoane a omorat Samson cu o falca de magar?', '1000', 'med', 5, '1000', '550', '700', '600'),
(16, 'Cine a intrat in Tara Fagaduintei?', 'Iosua si Caleb', 'med', 6, 'Dan si Manase', 'Iosua si Caleb', 'Ruben si Neftali', 'Moise si Iosua'),
(17, 'Care a fost primul om care a murit pe pamant?', 'Abel', 'med', 7, 'Cain', 'Adam', 'Abel', 'Eva'),
(18, 'Pe cati arginti l-a vandut Iuda pe Isus', '30', 'med', 8, '20', '25', '30', '35'),
(19, 'Care este cel mai mare psalm?', '119', 'med', 9, '120', '117', '119', '150'),
(20, 'Unde a fugit Iona de fata Domnului?', 'La Tars', 'med', 10, 'La Capernaum', 'In Galileea', 'La Tars', 'In Ninive'),
(21, 'Cate carti are Biblia?', '66', 'hard', 1, '60', '65', '70', '66'),
(22, 'In cati ani a fost scrisa Biblia?', '1500', 'hard', 2, '2000', '3500', '1500', '1000'),
(23, 'Care om nu a avut buric?', 'Adam', 'hard', 3, 'Eva', 'Moise', 'Adam', 'Ilie'),
(24, 'Cate persoane au primit Duhul Sfant, cand se rugau, dupa ce S-a inaltat Isus la Cer?', '120', 'hard', 4, '100', '200', '120', '500'),
(25, 'Cate zile a postit Isus in pustie?', '40', 'hard', 5, '22', '50', '40', '33'),
(26, 'Cine a scris cartea: Rut?', 'Samuel', 'hard', 6, 'Iosif', 'Rut', 'Samuel', 'Ieremia'),
(27, 'In ce an a fost scrisa cartea: Rut?', '1000 i.Hr.', 'hard', 7, '1000 i.Hr.', '1500 i.Hr.', '700 i.Hr.', '2000 i.Hr.'),
(28, 'Cati ani a durat cucerirea Canaanului?', '7 ani', 'hard', 8, '10 ani', '5 ani', '7 ani', '8 ani'),
(29, 'Cum se numeste in limba greaca: Evanghelia lui Luca?', 'Kata Loukon', 'hard', 9, 'Kata Loukon', 'Libra Lukos', 'Cartis de Luccas', 'Boke Luki'),
(30, 'In ce an a fost scrisa Apocalipsa?', '66-80 d.Hr.', 'hard', 10, '66-70 d.Hr.', '68-80 d.Hr.', '66-80 d.Hr.', '69-100 d.Hr.');

DROP TABLE IF EXISTS `quiz_membrii`;
CREATE TABLE IF NOT EXISTS `quiz_membrii` (
  `de` int(11) NOT NULL,
  `easy_question` char(2) NOT NULL DEFAULT '0',
  `easy_next` char(2) NOT NULL DEFAULT '0',
  `med_question` char(2) NOT NULL DEFAULT '0',
  `med_next` char(2) NOT NULL DEFAULT '0',
  `hard_question` char(2) NOT NULL DEFAULT '0',
  `hard_next` char(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `recupereaza`;
CREATE TABLE IF NOT EXISTS `recupereaza` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tip` int(1) NOT NULL,
  `pid` varchar(200) NOT NULL,
  `de` int(11) NOT NULL,
  `email` varchar(200) DEFAULT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rss`;
CREATE TABLE IF NOT EXISTS `rss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  `link` varchar(150) NOT NULL DEFAULT '',
  `srcd` varchar(200) NOT NULL DEFAULT '',
  `dscr` varchar(100) NOT NULL DEFAULT '',
  `imgsrc` varchar(100) NOT NULL DEFAULT '',
  `pubdate` varchar(50) NOT NULL DEFAULT '',
  `fid` int(11) NOT NULL DEFAULT '0',
  `lupdate` int(11) NOT NULL DEFAULT '0',
  `pgurl` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `rss_date`;
CREATE TABLE IF NOT EXISTS `rss_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rssid` int(11) NOT NULL DEFAULT '0',
  `nume` varchar(77) NOT NULL,
  `link` varchar(255) NOT NULL DEFAULT '',
  `imgsrc` varchar(255) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `pubdate` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `setari`;
CREATE TABLE IF NOT EXISTS `setari` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `nume` varchar(33) NOT NULL,
  `valoare` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO `setari` (`id`, `nume`, `valoare`) VALUES
(1, 'total_vizite', '1'),
(2, '1412710356', '1'),
(3, 'cron_zilnic', '2015-02-03'),
(4, 'cron_orar', '2015-02-03-14'),
(5, 'expirare_sesiune', '3600'),
(7, 'mesaj_prim', 'Bun venit pe filumina.ro'),
(9, 'mesaj_intampinare', 'iti multumim ca te-ai inregistrat pe filumina.ro![br/]Daca ai vreo problema, poti contacta echipa filumina.ro, deschizand un tichet, in centru suport.[br/]Daca iti place acest site, cheama-ti cati mai multi prieteni!'),
(10, 'mesaj_aniversar', 'multumeste-I Lui Dumnezeu ca te-a ajutat sa ajungi la aceasta varsta, sa ai parte de tot ce iti doresti, alaturi de cei dragi, si de filumina.ro!'),
(11, 'mesaj_galerie', 'Daca nu puteti adauga poze, puteti sa le trimiteti prin MMS la 0741476860, sau pe e-mail la admin@filumina.ro, specificand nick-ul de pe filumina.ro.'),
(12, 'email_admin', 'admin@filumina.ro'),
(13, 'telefon_admin', '0741476860'),
(15, 'inregistrare_membri', '1'),
(16, 'validare_membri', '1'),
(20, '16', '384'),
(21, 'status_quizz', '1'),
(22, '1422533257', '2');

DROP TABLE IF EXISTS `setari_jocuri`;
CREATE TABLE IF NOT EXISTS `setari_jocuri` (
  `nume` varchar(33) NOT NULL,
  `valoare1` text NOT NULL,
  `valoare2` text NOT NULL,
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `setari_jocuri` (`nume`, `valoare1`, `valoare2`) VALUES
('anagrame1', '0', '0'),
('anagrame2', '0', '0'),
('spune_cartea1', '0', '0'),
('spune_cartea2', '0', '0'),
('trivia1', '0', '0'),
('trivia2', '0', '0');

DROP TABLE IF EXISTS `sms`;
CREATE TABLE IF NOT EXISTS `sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sms_abonati`;
CREATE TABLE IF NOT EXISTS `sms_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sms_aprecieri`;
CREATE TABLE IF NOT EXISTS `sms_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sms_categorii`;
CREATE TABLE IF NOT EXISTS `sms_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sms_comentarii`;
CREATE TABLE IF NOT EXISTS `sms_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sms_note`;
CREATE TABLE IF NOT EXISTS `sms_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `spune_cartea_conectati`;
CREATE TABLE IF NOT EXISTS `spune_cartea_conectati` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`data`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `spune_cartea_raspunsuri`;
CREATE TABLE IF NOT EXISTS `spune_cartea_raspunsuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stiri`;
CREATE TABLE IF NOT EXISTS `stiri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `vizualizari` int(11) NOT NULL DEFAULT '0',
  `pret_com` int(4) NOT NULL DEFAULT '0',
  `pret_rate` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stiri_abonati`;
CREATE TABLE IF NOT EXISTS `stiri_abonati` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stiri_aprecieri`;
CREATE TABLE IF NOT EXISTS `stiri_aprecieri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stiri_categorii`;
CREATE TABLE IF NOT EXISTS `stiri_categorii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nume` (`nume`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stiri_comentarii`;
CREATE TABLE IF NOT EXISTS `stiri_comentarii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `stiri_note`;
CREATE TABLE IF NOT EXISTS `stiri_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `valoare` int(2) NOT NULL,
  `pret` int(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_ajutor`;
CREATE TABLE IF NOT EXISTS `t2_ajutor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` varchar(100) NOT NULL,
  `la` varchar(100) NOT NULL,
  `arcasi` varchar(100) NOT NULL,
  `cavalerie` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `lanc` varchar(100) NOT NULL,
  `lpsp` varchar(100) NOT NULL,
  `lptp` varchar(100) NOT NULL,
  `spio` varchar(100) NOT NULL,
  `cvus` varchar(100) NOT NULL,
  `cvgr` varchar(100) NOT NULL,
  `tip` varchar(100) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_argila`;
CREATE TABLE IF NOT EXISTS `t2_argila` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `t2_argila` (`id`, `lvl`, `lmn`, `arg`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '65', '50', '40', '389', '10', '30'),
(2, '2', '83', '63', '50', '486', '1', '36'),
(3, '3', '105', '80', '62', '583', '2', '42'),
(4, '4', '133', '101', '76', '680', '2', '50'),
(5, '5', '169', '128', '95', '777', '2', '59'),
(6, '6', '215', '162', '117', '874', '2', '70'),
(7, '7', '273', '205', '145', '971', '3', '83'),
(8, '8', '346', '259', '180', '1068', '3', '98'),
(9, '9', '440', '328', '224', '1165', '4', '117'),
(10, '10', '559', '415', '277', '1262', '4', '138'),
(11, '11', '709', '525', '344', '1359', '4', '164'),
(12, '12', '901', '664', '426', '1456', '5', '194'),
(13, '13', '1144', '840', '529', '1553', '6', '230'),
(14, '14', '1453 ', '1062', '655', '1650', '7', '273'),
(15, '15', '1846 ', '1343', '813', '1747', '8', '323'),
(16, '16', '2344', '1700', '1008', '1844', '8', '383'),
(17, '17', '2977', '2150', '1250', '1941', '10', '454'),
(18, '18', '3781', '2720', '1550', '2038', '12', '537'),
(19, '19', '4802', '3440', '1922', '2135', '13', '637'),
(20, '20', '6098', '4352', '2383', '2232', '15', '755'),
(21, '21', '7744', '5505', '2955', '2329', '16', '894'),
(22, '22', '9835', '6964', '3664', '2426', '20', '1060'),
(23, '23', '12491', '8810', '4543', '2523', '22', '1256'),
(24, '24', '15863', '11144', '5633', '2620', '25', '1488'),
(25, '25', '20147', '14098', '6985', '2717', '28', '1763'),
(26, '26', '25586', '17833', '8662', '2814', '33', '2090'),
(27, '27', '32495', '22559', '10740', '2911', '37', '2476'),
(28, '28', '41268', '28537', '13318', '3008', '42', '2934'),
(29, '29', '52410', '36100', '16515', '3105', '48', '3477'),
(30, '30', '66561', '45666', '20478', '3202', '55', '4121'),
(31, '31', '71324', '52787', '26226', '3592', '64', '5964'),
(32, '32', '78466', '59898', '31876', '3922', '78', '6792');

DROP TABLE IF EXISTS `t2_armata`;
CREATE TABLE IF NOT EXISTS `t2_armata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` varchar(100) NOT NULL,
  `tip` varchar(100) NOT NULL,
  `nr` int(11) NOT NULL,
  `data` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `sat` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_ascunzatoare`;
CREATE TABLE IF NOT EXISTS `t2_ascunzatoare` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO `t2_ascunzatoare` (`id`, `lvl`, `arg`, `lmn`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '60', '50', '50', '789', '2', '100'),
(2, '2', '75', '63', '63', '1023', '0', '135'),
(3, '3', '94', '78', '78', '1257', '1', '183'),
(4, '4', '117', '98', '98', '1491', '0', '247'),
(5, '5', '146', '122', '122', '1725', '1', '333'),
(6, '6', '183', '153', '153', '1959', '0', '450'),
(7, '7', '229', '191', '191', '2193', '1', '608'),
(8, '8', '286', '238', '238', '2427', '1', '822'),
(9, '9', '358', '298', '298', '2661', '1', '1110'),
(10, '10', '447', '373', '373', '2895', '1', '1500'),
(11, '11', '530', '490', '490', '3126', '1', '1750'),
(12, '12', '720', '619', '619', '3510', '1', '1900'),
(13, '13', '845', '769', '769', '3992', '1', '2150'),
(14, '14', '920', '810', '810', '4180', '1', '2300'),
(15, '15', '990', '940', '940', '4512', '1', '2450'),
(16, '16', '1010', '1000', '1000', '4622', '1', '2590'),
(17, '17', '1060', '1020', '1020', '4700', '1', '2630'),
(18, '18', '1080', '1040', '1040', '4746', '1', '2690'),
(19, '19', '1120', '1060', '1060', '4760', '1', '2720'),
(20, '20', '1140', '1080', '1080', '4785', '1', '2890');

DROP TABLE IF EXISTS `t2_cazermata`;
CREATE TABLE IF NOT EXISTS `t2_cazermata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `t2_cazermata` (`id`, `lvl`, `arg`, `lmn`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '170', '200', '90', '745', '7', '789'),
(2, '2', '218', '252', '113', '957', '1', '678'),
(3, '3', '279', '318', '143', '1169', '2', '665'),
(4, '4', '357', '400', '180', '1381', '1', '634'),
(5, '5', '456', '504', '227', '1593', '2', '612'),
(6, '6', '584', '635', '286', '1805', '2', '598'),
(7, '7', '748', '800', '360', '2017', '3', '567'),
(8, '8', '957', '1008', '454', '2229', '3', '546'),
(9, '9', '1225', '1271', '572', '2441', '4', '526'),
(10, '10', '1568', '1601', '720', '2653', '4', '499'),
(11, '11', '2017', '2007', '908', '2753', '5', '455'),
(12, '12', '2569', '2542', '1144', '2865', '5', '434'),
(13, '13', '3288', '3202', '1441', '3077', '7', '421'),
(14, '14', '4209', '4035', '1816', '3289', '8', '400'),
(15, '15', '5388', '5084', '2288', '3501', '9', '389'),
(16, '16', '6896', '6406', '2883', '3713', '11', '375'),
(17, '17', '8827', '8072', '3632', '3925', '12', '354'),
(18, '18', '11298', '10170', '4577', '4137', '15', '335'),
(19, '19', '14462', '12814', '5767', '4349', '17', '310'),
(20, '20', '18511', '16146', '7266', '4561', '20', '289'),
(21, '21', '23695', '20344', '9155', '4773', '24', '256'),
(22, '22', '30329', '25634', '11535', '4985', '27', '210'),
(23, '23', '38821', '32298', '14534', '5197', '32', '198'),
(24, '24', '49691', '40696', '18313', '5409', '38', '170'),
(25, '25', '63605', '51277', '23075', '5621', '44', '120'),
(26, '26', '100307', '90932', '89462', '7232', '47', '217'),
(27, '27', '140266', '110424', '110560', '9872', '50', '240'),
(28, '28', '170578', '134237', '134266', '10348', '55', '270'),
(29, '29', '190888', '167234', '165868', '10989', '60', '290');

DROP TABLE IF EXISTS `t2_cladire_principala`;
CREATE TABLE IF NOT EXISTS `t2_cladire_principala` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `t2_cladire_principala` (`id`, `lvl`, `arg`, `lmn`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '80', '90', '70', '369', '5', ''),
(2, '2', '102', '113', '88', '420', '6', ''),
(3, '3', '130', '143', '111', '479', '7', ''),
(4, '4', '166', '180', '140', '489', '8', ''),
(5, '5', '211', '227', '176', '500', '9', ''),
(6, '6', '270', '286', '222', '540', '11', ''),
(7, '7', '344', '360', '280', '570', '13', ''),
(8, '8', '438', '454', '353', '596', '15', ''),
(9, '9', '559', '572', '445', '610', '18', ''),
(10, '10', '712', '720', '560', '630', '21', ''),
(11, '11', '908', '908', '706', '670', '24', ''),
(12, '12', '1159', '1144', '980', '796', '28', ''),
(13, '13', '1476', '1441', '1121', '809', '33', ''),
(14, '14', '1882', '1816', '1412', '1035', '38', ''),
(15, '15', '2400', '2288', '1779', '1135', '45', ''),
(16, '16', '3060', '2883', '2242', '1265', '53', ''),
(17, '17', '3902', '3632', '2825', '1370', '62', ''),
(18, '18', '4975', '4577', '3560', '1400', '72', ''),
(19, '19', '6343', '5767', '4485', '1654', '84', ''),
(20, '20', '8087', '7266', '5651', '1876', '99', ''),
(21, '21', '10311', '9155', '7120', '2134', '116', ''),
(22, '22', '13146', '11535', '8972', '2344', '135', ''),
(23, '23', '16762', '14534', '11304', '2456', '158', ''),
(24, '24', '21371', '18313', '14244', '2500', '185', ''),
(25, '25', '27248', '23075', '17947', '2770', '216', ''),
(26, '26', '34741', '29074', '22613', '3456', '253', ''),
(27, '27', '44295', '36633', '28493', '3523', '296', ''),
(28, '28', '56476', '46158', '35901', '3690', '347', ''),
(29, '29', '72007', '58159', '45235', '3768', '406', ''),
(30, '30', '91809', '73280', '56996', '3897', '475', '');

DROP TABLE IF EXISTS `t2_conectati`;
CREATE TABLE IF NOT EXISTS `t2_conectati` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`data`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_ferma`;
CREATE TABLE IF NOT EXISTS `t2_ferma` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

INSERT INTO `t2_ferma` (`id`, `lvl`, `lmn`, `arg`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '45', '40', '30', '567', '0', '240'),
(2, '2', '59', '53', '39', '721', '0', '280'),
(3, '3', '76', '70', '50', '875', '0', '328'),
(4, '4', '99', '92', '64', '1029', '0', '384'),
(5, '5', '129', '121', '83', '1183', '0', '449'),
(6, '6', '167', '160', '107', '1337', '0', '526'),
(7, '7', '217', '212', '138', '1491', '0', '615'),
(8, '8', '282', '279', '178', '1645', '0', '720'),
(9, '9', '367', '369', '230', '1799', '0', '842'),
(10, '10', '477', '487', '297', '1953', '0', '986'),
(11, '11', '620', '642', '383', '2107', '0', '1153'),
(12, '12', '806', '848', '494', '2261', '0', '1349'),
(13, '13', '1048', '1119', '637', '2415', '0', '1579'),
(14, '14', '1363', '1477', '822', '2569', '0', '1847'),
(15, '15', '1772', '1950', '1060', '2723', '0', '2161'),
(16, '16', '2303', '2574', '1368', '2877', '0', '2529'),
(17, '17', '2994', '3398', '1764', '3031', '0', '2959'),
(18, '18', '3893', '4486', '2276', '3185', '0', '3462'),
(19, '19', '5060', '5921', '2936', '3339', '0', '4050'),
(20, '20', '6579', '7816', '3787', '3493', '0', '4739'),
(21, '21', '8552', '10317', '4886', '3647', '0', '5545'),
(22, '22', '11118', '13618', '6302', '3801', '0', '6488'),
(23, '23', '14453', '17976', '8130', '3955', '0', '7591'),
(24, '24', '18789', '23728', '10488', '4109', '0', '8881'),
(25, '25', '24426', '31321', '13529', '4263', '0', '10391'),
(26, '26', '31754', '41344', '17453', '4417', '0', '12157'),
(27, '27', '41280', '54574', '22514', '4571', '0', '14224'),
(28, '28', '53664', '72037', '29043', '4725', '0', '16642'),
(29, '29', '69763', '95089', '37466', '4879', '0', '19472'),
(30, '30', '90692', '125517', '48331', '5033', '0', '22782'),
(31, '31', '113436', '146327', '63725', '5733', '0', '25868'),
(32, '32', '134226', '162458', '76234', '6145', '0', '28922'),
(33, '33', '150684', '182457', '84488', '7255', '0', '32786'),
(34, '34', '178923', '198556', '92862', '8046', '0', '35288');

DROP TABLE IF EXISTS `t2_fierarie`;
CREATE TABLE IF NOT EXISTS `t2_fierarie` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO `t2_fierarie` (`id`, `lvl`, `arg`, `lmn`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '180', '220', '240', '547', '20', ''),
(2, '2', '229', '277', '302', '701', '3', ''),
(3, '3', '293', '349', '381', '855', '4', ''),
(4, '4', '373', '440', '480', '1009', '5', ''),
(5, '5', '476', '555', '605', '1163', '5', ''),
(6, '6', '606', '699', '762', '1317', '7', ''),
(7, '7', '773', '880', '960', '1471', '7', ''),
(8, '8', '986', '1109', '1210', '1625', '9', ''),
(9, '9', '1257', '1398', '1525', '1779', '10', ''),
(10, '10', '1603', '1761', '1921', '1933', '12', ''),
(11, '11', '2043', '2219', '2421', '2087', '14', ''),
(12, '12', '2605', '2796', '3050', '2241', '16', ''),
(13, '13', '3322', '3523', '3843', '2395', '20', ''),
(14, '14', '4236', '4439', '4842', '2549', '22', ''),
(15, '15', '5400', '5593', '6101', '2703', '26', ''),
(16, '16', '6885', '7047', '7687', '2857', '31', ''),
(17, '17', '8779', '8879', '9686', '3011', '36', ''),
(18, '18', '11193', '11187', '12204', '3165', '42', ''),
(19, '19', '14271', '14096', '15377', '3319', '49', ''),
(20, '20', '18196', '17761', '9375', '3473', '57', '');

DROP TABLE IF EXISTS `t2_grajd`;
CREATE TABLE IF NOT EXISTS `t2_grajd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO `t2_grajd` (`id`, `lvl`, `arg`, `lmn`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '240', '270', '260', '875', '8', '987'),
(2, '2', '307', '340', '328', '1029', '1', '953'),
(3, '3', '393', '429', '413', '1183', '2', '919'),
(4, '4', '503', '540', '520', '1337', '2', '885'),
(5, '5', '644', '681', '655', '1491', '2', '851'),
(6, '6', '825', '857', '826', '1645', '3', '817'),
(7, '7', '1056', '1080', '1040', '1799', '3', '783'),
(8, '8', '1351', '1361', '1311', '1953', '3', '749'),
(9, '9', '1729', '1715', '1652', '2107', '4', '715'),
(10, '10', '2214', '2161', '2081', '2261', '5', '681'),
(11, '11', '2833', '2723', '2622', '2415', '5', '647'),
(12, '12', '3627', '3431', '3304', '2569', '7', '613'),
(13, '13', '4642', '4323', '4163', '2723', '8', '579'),
(14, '14', '5942', '5447', '5246', '2877', '9', '545'),
(15, '15', '7606', '6864', '6609', '3031', '10', '511'),
(16, '16', '9736', '8648', '8328', '3185', '12', '477'),
(17, '17', '12462', '10897', '10493', '3339', '15', '443'),
(18, '18', '15951', '13730', '13221', '3493', '16', '409'),
(19, '19', '20417', '17300', '16659', '3647', '20', '375'),
(20, '20', '26134', '21797', '20990', '3801', '23', '341');

DROP TABLE IF EXISTS `t2_invitatii`;
CREATE TABLE IF NOT EXISTS `t2_invitatii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` varchar(100) NOT NULL,
  `la` varchar(100) NOT NULL,
  `data` varchar(100) NOT NULL,
  `sat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_lemn`;
CREATE TABLE IF NOT EXISTS `t2_lemn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `t2_lemn` (`id`, `lvl`, `lmn`, `arg`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '50', '60', '40', '489', '5', '30'),
(2, '2', '63', '77', '50', '626', '1', '36'),
(3, '3', '78', '98', '62', '763', '1', '42'),
(4, '4', '98', '124', '77', '900', '1', '50'),
(5, '5', '122', '159', '96', '1037', '1', '59'),
(6, '6', '153', '202', '120', '1174', '1', '70'),
(7, '7', '191', '258', '149', '1311', '2', '83'),
(8, '8', '238', '329', '185', '1448', '2', '98'),
(9, '9', '298', '419', '231', '1585', '2', '117'),
(10, '10', '373', '534', '287', '1722', '2', '138'),
(11, '11', '466', '681', '358', '1859', '3', '164'),
(12, '12', '582', '868', '446', '1996', '3', '194'),
(13, '13', '728', '1107', '555', '2133', '4', '230'),
(14, '14', '909', '1412', '691', '2270', '5', '273'),
(15, '15', '1137', '1800', '860', '2407', '5', '323'),
(16, '16', '1421', '2295', '1071', '2544', '5', '383'),
(17, '17', '1776', '2926', '1333', '2681', '7', '454'),
(18, '18', '2220', '3731', '1659', '2818', '8', '537'),
(19, '19', '2776', '4757', '2066', '2955', '9', '637'),
(20, '20', '3469', '6065', '2572', '3092', '10', '755'),
(21, '21', '4337', '7733', '3202', '3229', '12', '894'),
(22, '22', '5421', '9860', '3987', '3366', '14', '1060'),
(23, '23', '6776', '12571', '4963', '3503', '16', '1256'),
(24, '24', '8470', '16028', '6180', '3640', '19', '1488'),
(25, '25', '10588', '20436', '7694', '3777', '21', '1763'),
(26, '26', '13235', '26056', '9578', '3914', '24', '2090'),
(27, '27', '16544', '33221', '11925', '4051', '29', '2476'),
(28, '28', '20680', '42357', '14847', '4188', '33', '2934'),
(29, '29', '25849', '54005', '18484', '4325', '38', '3477'),
(30, '30', '32312', '68857', '23013', '4462', '43', '4121'),
(31, '31', '35315', '72878', '26016', '4787', '57', '5378'),
(32, '32', '38318', '78767', '29019', '5010', '65', '6019');

DROP TABLE IF EXISTS `t2_magazie`;
CREATE TABLE IF NOT EXISTS `t2_magazie` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` int(11) NOT NULL,
  `pop` int(11) NOT NULL,
  `cant` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `t2_magazie` (`id`, `lvl`, `lmn`, `arg`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '60', '50', '40', 875, 0, 1000),
(2, '2', '76', '64', '50', 1029, 0, 1230),
(3, '3', '96', '81', '62', 1183, 0, 1513),
(4, '4', '121', '102', '77', 1337, 0, 1861),
(5, '5', '154', '130', '96', 1491, 0, 2289),
(6, '6', '194', '165', '120', 1645, 0, 2815),
(7, '7', '246', '210', '149', 1799, 0, 3463),
(8, '8', '311', '266', '185', 1953, 0, 4259),
(9, '9', '393', '338', '231', 2107, 0, 5239),
(10, '10', '498', '430', '287', 2261, 0, 6444),
(11, '11', '630', '546', '358', 2415, 0, 7926),
(12, '12', '796', '693', '446', 2569, 0, 9749),
(13, '13', '1007', '880', '555', 2723, 0, 11991),
(14, '14', '1274', '1118', '691', 2877, 0, 14749),
(15, '15', '1612', '1420', '860', 3031, 0, 18141),
(16, '16', '2039', '1803', '1071', 3185, 0, 22314),
(17, '17', '2580', '2290', '1333', 3339, 0, 27446),
(18, '18', '3264', '2908', '1659', 3493, 0, 33759),
(19, '19', '4128', '3693', '2066', 3647, 0, 41523),
(20, '20', '5222', '4691', '2572', 3801, 0, 51074),
(21, '21', '6606', '5957', '3202', 3955, 0, 62821),
(22, '22', '8357', '7566', '3987', 4109, 0, 77269),
(23, '23', '10572', '9608', '4963', 4263, 0, 95041),
(24, '24', '13373', '12203', '6180', 4417, 0, 116901),
(25, '25', '16917', '15497', '7694', 4571, 0, 143788),
(26, '26', '21400', '19682', '9578', 4725, 0, 176859),
(27, '27', '27071', '24996', '11925', 4879, 0, 217537),
(28, '28', '34245', '31745', '14847', 5033, 0, 267570),
(29, '29', '43320', '40316', '18484', 5187, 0, 329112),
(30, '30', '54799', '51201', '23013', 5341, 0, 404807);

DROP TABLE IF EXISTS `t2_membrii`;
CREATE TABLE IF NOT EXISTS `t2_membrii` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` varchar(100) NOT NULL,
  `sat` varchar(100) NOT NULL,
  `trib` varchar(100) NOT NULL,
  `idtrib` int(11) NOT NULL,
  `pop` varchar(100) NOT NULL DEFAULT '100',
  `lvlpop` varchar(100) NOT NULL DEFAULT '0',
  `lvlarg` varchar(100) NOT NULL DEFAULT '9',
  `lvllmn` varchar(100) NOT NULL DEFAULT '10',
  `lvlptr` varchar(100) NOT NULL DEFAULT '9',
  `lvlarm` varchar(100) NOT NULL DEFAULT '0',
  `lvlmag` varchar(100) NOT NULL DEFAULT '2',
  `lvlfrm` varchar(100) NOT NULL DEFAULT '1',
  `lvlasc` varchar(100) NOT NULL DEFAULT '1',
  `lvlzid` varchar(100) NOT NULL DEFAULT '0',
  `lvlcal` varchar(100) NOT NULL DEFAULT '0',
  `lmn` int(11) NOT NULL DEFAULT '200',
  `ptr` int(11) NOT NULL DEFAULT '200',
  `arg` int(11) NOT NULL DEFAULT '200',
  `arm` varchar(100) NOT NULL DEFAULT '0',
  `cal` varchar(100) NOT NULL DEFAULT '0',
  `pct` int(11) NOT NULL DEFAULT '121',
  `moral` varchar(100) NOT NULL DEFAULT '100',
  `data` varchar(100) NOT NULL,
  `lvlprin` varchar(100) NOT NULL DEFAULT '1',
  `poptot` int(11) NOT NULL DEFAULT '120',
  `lvlfer` varchar(100) NOT NULL DEFAULT '0',
  `updaterl` int(11) NOT NULL,
  `updatera` int(11) NOT NULL,
  `updaterp` int(11) NOT NULL,
  `protect` varchar(100) NOT NULL DEFAULT '0',
  `premiu` varchar(10) NOT NULL DEFAULT '0',
  `premiuda` varchar(100) NOT NULL,
  `lanc` int(11) NOT NULL DEFAULT '0',
  `lpsp` int(11) NOT NULL DEFAULT '0',
  `lptp` int(11) NOT NULL DEFAULT '0',
  `spio` int(11) NOT NULL DEFAULT '0',
  `cvus` int(11) NOT NULL DEFAULT '0',
  `cvgr` int(11) NOT NULL DEFAULT '0',
  `desc` varchar(250) NOT NULL,
  `corx` varchar(100) NOT NULL,
  `cory` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_piatra`;
CREATE TABLE IF NOT EXISTS `t2_piatra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `t2_piatra` (`id`, `lvl`, `lmn`, `arg`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '75', '65', '70', '494', '10', '30'),
(2, '2', '94', '83', '87', '640', '2', '36'),
(3, '3', '118', '106', '108', '786', '2', '42'),
(4, '4', '147', '135', '133', '932', '2', '50'),
(5, '5', '184', '172', '165', '1078', '3', '59'),
(6, '6', '231', '219', '205', '1224', '3', '70'),
(7, '7', '289', '279', '254', '1370', '4', '83'),
(8, '8', '362', '356', '316', '1516', '4', '98'),
(9, '9', '453', '454', '391', '1662', '5', '117'),
(10, '10', '567', '579', '485', '1808', '6', '138'),
(11, '11', '710', '738', '602', '1954', '7', '164'),
(12, '12', '889', '941', '746', '2100', '8', '194'),
(13, '13', '1113', '1200', '925', '2246', '10', '230'),
(14, '14', '1393', '1529', '1147', '2392', '11', '273'),
(15, '15', '1744', '1950', '1422', '2538', '13', '323'),
(16, '16', '2183', '2486', '1764', '2684', '15', '383'),
(17, '17', '2734', '3170', '2187', '2830', '18', '454'),
(18, '18', '3422', '4042', '2712', '2976', '21', '537'),
(19, '19', '4285', '5153', '3363', '3122', '25', '637'),
(20, '20', '5365', '6571', '4170', '3268', '28', '755'),
(21, '21', '6717', '8378', '5170', '3414', '34', '894'),
(22, '22', '8409', '10681', '6411', '3560', '39', '1060'),
(23, '23', '10528', '13619', '7950', '3706', '46', '1256'),
(24, '24', '13181', '17364', '9858', '3852', '54', '1488'),
(25, '25', '16503', '22139', '12224', '3998', '63', '1763'),
(26, '26', '20662', '28227', '15158', '4144', '74', '2090'),
(27, '27', '25869', '35990', '18796', '4290', '86', '2476'),
(28, '28', '32388', '45887', '23307', '4436', '100', '2934'),
(29, '29', '40549', '58506', '28900', '4582', '118', '3477'),
(30, '30', '50768', '74595', '35837', '4728', '138', '4121'),
(31, '31', '55789', '79456', '38977', '4843', '89', '5632'),
(32, '32', '60564', '83234', '41545', '4986', '78', '6246');

DROP TABLE IF EXISTS `t2_procese`;
CREATE TABLE IF NOT EXISTS `t2_procese` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` varchar(100) NOT NULL,
  `tip` varchar(100) NOT NULL,
  `lvl` varchar(100) NOT NULL,
  `data` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `sat` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_rapoarte`;
CREATE TABLE IF NOT EXISTS `t2_rapoarte` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `la` varchar(100) NOT NULL,
  `text` varchar(250) NOT NULL,
  `data` int(11) NOT NULL,
  `citit` int(11) NOT NULL DEFAULT '0',
  `subiect` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_targ`;
CREATE TABLE IF NOT EXISTS `t2_targ` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` varchar(100) NOT NULL,
  `ofer` varchar(100) NOT NULL,
  `ofer1` varchar(100) NOT NULL,
  `pentru` varchar(100) NOT NULL,
  `pentru1` varchar(100) NOT NULL,
  `data` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_triburi`;
CREATE TABLE IF NOT EXISTS `t2_triburi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `nume` varchar(100) NOT NULL,
  `data` int(11) NOT NULL,
  `desc` varchar(250) NOT NULL,
  `pct` int(11) NOT NULL DEFAULT '100',
  `sat` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t2_zid`;
CREATE TABLE IF NOT EXISTS `t2_zid` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` varchar(100) NOT NULL,
  `arg` varchar(100) NOT NULL,
  `lmn` varchar(100) NOT NULL,
  `ptr` varchar(100) NOT NULL,
  `timp` varchar(100) NOT NULL,
  `pop` varchar(100) NOT NULL,
  `cant` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO `t2_zid` (`id`, `lvl`, `arg`, `lmn`, `ptr`, `timp`, `pop`, `cant`) VALUES
(1, '1', '50', '100', '20', '875', '5', '104'),
(2, '2', '63', '127', '25', '1029', '1', '108'),
(3, '3', '79', '163', '32', '1183', '1', '112'),
(4, '4', '100', '207', '40', '1337', '1', '116'),
(5, '5', '126', '264', '50', '1491', '1', '120'),
(6, '6', '159', '337', '64', '1645', '2', '124'),
(7, '7', '200', '430', '80', '1799', '2', '129'),
(8, '8', '252', '548', '101', '1953', '2', '134'),
(9, '9', '318', '698', '127', '2107', '3', '139'),
(10, '10', '400', '890', '160', '2261', '3', '144'),
(11, '11', '504', '1135', '202', '2415', '3', '149'),
(12, '12', '635', '1447', '254', '2569', '4', '155'),
(13, '13', '801', '1846', '320', '2723', '5', '160'),
(14, '14', '1009', '2353', '404', '2877', '5', '166'),
(15, '15', '1271', '3000', '508', '3031', '7', '172'),
(16, '16', '1607', '3825', '641', '3185', '8', '179'),
(17, '17', '2018', '4877', '807', '3339', '9', '185'),
(18, '18', '2543', '6218', '1017', '3493', '10', '192'),
(19, '19', '3207', '7928', '1281', '3647', '12', '199'),
(20, '20', '4037', '10109', '1615', '3801', '15', '207'),
(21, '21', '4500', '11230', '1814', '4022', '18', '324'),
(22, '22', '5400', '13420', '2420', '6844', '22', '462'),
(23, '23', '6650', '15138', '2962', '7846', '28', '596'),
(24, '24', '7842', '17328', '3462', '8930', '36', '722'),
(25, '25', '8320', '19428', '4212', '9236', '40', '800');

DROP TABLE IF EXISTS `tari`;
CREATE TABLE IF NOT EXISTS `tari` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `nume` varchar(77) NOT NULL,
  `cod` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `tari` (`id`, `nume`, `cod`) VALUES
(1, 'Afganistan', 'AF');

DROP TABLE IF EXISTS `tichet_intrebari`;
CREATE TABLE IF NOT EXISTS `tichet_intrebari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `nume` varchar(77) NOT NULL,
  `text` text NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `tichet_raspunsuri`;
CREATE TABLE IF NOT EXISTS `tichet_raspunsuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `trivia_conectati`;
CREATE TABLE IF NOT EXISTS `trivia_conectati` (
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`data`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `trivia_intrebari`;
CREATE TABLE IF NOT EXISTS `trivia_intrebari` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `intrebare` text NOT NULL,
  `raspuns` text NOT NULL,
  `valid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `trivia_raspunsuri`;
CREATE TABLE IF NOT EXISTS `trivia_raspunsuri` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `data` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vizitatori`;
CREATE TABLE IF NOT EXISTS `vizitatori` (
  `data` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `browser` varchar(255) NOT NULL,
  `link` varchar(333) NOT NULL,
  `actiune` varchar(77) NOT NULL,
  UNIQUE KEY `browser` (`browser`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `x_0`;
CREATE TABLE IF NOT EXISTS `x_0` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `la` int(11) NOT NULL,
  `miza` int(4) NOT NULL,
  `numar_runda` int(2) NOT NULL DEFAULT '0',
  `numar_runde` int(2) NOT NULL,
  `primul` int(11) NOT NULL,
  `ultimul` int(11) NOT NULL DEFAULT '0',
  `primul_scor` int(5) NOT NULL DEFAULT '0',
  `al_doilea_scor` int(5) NOT NULL DEFAULT '0',
  `cod` varchar(9) NOT NULL DEFAULT '---------',
  `cod_temporar` varchar(9) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `x_0_jurnal`;
CREATE TABLE IF NOT EXISTS `x_0_jurnal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de` int(11) NOT NULL,
  `victorii` int(11) NOT NULL,
  `runde` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `de` (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
COMMIT;
